package furny.ga.logger.entities;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import furny.ga.RoomVector;

/**
 * Database entry for an genotype.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
@Entity
@Cache(usage = CacheConcurrencyStrategy.READ_ONLY)
public final class GeneEntry {

  /** The id. */
  private long id;

  /** The x gene. */
  private int xGene;

  /** The y gene. */
  private int yGene;

  /** The rot gene. */
  private int rotGene;

  /** The furn id. */
  private long furnId;

  /**
   * Instantiates a new gene entry.
   */
  private GeneEntry() {
  }

  /**
   * Instantiates a new gene entry.
   * 
   * @param vector
   *          the vector
   * @param furnId
   *          the furn id
   */
  public GeneEntry(final RoomVector vector, final long furnId) {
    this.xGene = vector.getXGene();
    this.yGene = vector.getYGene();
    this.rotGene = vector.getRotationSteps();
    this.furnId = furnId;
  }

  /**
   * Gets the id.
   * 
   * @return the id
   */
  @Id
  @GeneratedValue
  public long getId() {
    return id;
  }

  /**
   * Sets the id.
   * 
   * @param id
   *          the new id
   */
  private void setId(final long id) {
    this.id = id;
  }

  /**
   * Gets the x gene.
   * 
   * @return the x gene
   */
  public int getXGene() {
    return xGene;
  }

  /**
   * Sets the x gene.
   * 
   * @param x
   *          the new x gene
   */
  public void setXGene(final int x) {
    this.xGene = x;
  }

  /**
   * Gets the y gene.
   * 
   * @return the y gene
   */
  public int getYGene() {
    return yGene;
  }

  /**
   * Sets the y gene.
   * 
   * @param y
   *          the new y gene
   */
  public void setYGene(final int y) {
    this.yGene = y;
  }

  /**
   * Gets the rot gene.
   * 
   * @return the rot gene
   */
  public int getRotGene() {
    return rotGene;
  }

  /**
   * Sets the rot gene.
   * 
   * @param rotation
   *          the new rot gene
   */
  public void setRotGene(final int rotation) {
    this.rotGene = rotation;
  }

  /**
   * Gets the furn id.
   * 
   * @return the furn id
   */
  public long getFurnId() {
    return furnId;
  }

  /**
   * Sets the furn id.
   * 
   * @param furnId
   *          the new furn id
   */
  public void setFurnId(final long furnId) {
    this.furnId = furnId;
  }

}
